%------------------------------------------------------------------------------
% File     : SWV447^1 : TPTP v7.4.0. Released v3.7.0.
% Domain   : Software Verification
% Problem  : Nipkow's simple map-cons problem
% Version  : Especial.
% English  :

% Refs     :
% Source   : [TPTP]
% Names    :

% Status   : Theorem
% Rating   : 0.00 v6.2.0, 0.14 v6.1.0, 0.00 v6.0.0, 0.14 v5.5.0, 0.33 v5.4.0, 0.40 v5.3.0, 0.60 v5.2.0, 0.40 v5.1.0, 0.20 v5.0.0, 0.40 v4.1.0, 0.33 v3.7.0
% Syntax   : Number of formulae    :    6 (   0 unit;   3 type;   0 defn)
%            Number of atoms       :   26 (   3 equality;  11 variable)
%            Maximal formula depth :    8 (   5 average)
%            Number of connectives :   17 (   0   ~;   0   |;   0   &;  17   @)
%                                         (   0 <=>;   0  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    7 (   7   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    4 (   3   :;   0   =)
%            Number of variables   :    6 (   0 sgn;   5   !;   0   ?;   1   ^)
%                                         (   6   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
%------------------------------------------------------------------------------
thf(nil_type,type,(
    nil: $i )).

thf(cons_type,type,(
    cons: $i > $i > $i )).

thf(map_type,type,(
    map: ( $i > $i ) > $i > $i )).

thf(ax1,axiom,(
    ! [F: $i > $i] :
      ( ( map @ F @ nil )
      = nil ) )).

thf(ax2,axiom,(
    ! [F: $i > $i,X: $i,Y: $i] :
      ( ( map @ F @ ( cons @ X @ Y ) )
      = ( cons @ ( F @ X ) @ ( map @ F @ Y ) ) ) )).

thf(test,conjecture,(
    ! [A: $i] :
      ( ( map
        @ ^ [X: $i] : X
        @ ( cons @ A @ nil ) )
      = ( cons @ A @ nil ) ) )).

%------------------------------------------------------------------------------
